// Illustration of a loop: the logarithmic spiral
import java.io.*;
import java.awt.*;

// Logarithmic spiral example
public class Spiral extends Frame {
  private final int hc= 300;   // Center of spiral 
  private final int vc= 250;   //    is (hc,vc)
  private final int n= 2000;   // Number of sides to draw
  private final double d= .2;  // Length of leg k is k*d
  private int turn= 120;       // The turn factor
  
  // Set the turn between successive lines to t
  public void setTurn(int t) {
    turn= t;
  }
  
  // The spiral consists of n line segments. Line segment 1
  // has starting point (hc, vc). Line segment k, for
  // 1<=k<=n, has length k*d. Each line segment makes an
  // angle of turn degrees with the previous line segment.
  // The colors of the lines alternate between red, blue,
  // and green.
  
  public void paint(Graphics g) {
    int h= hc;
    int v= vc;
    int k= 1;
    //Invariant: legs 1..k-1 have been drawn, and leg k is
    //           to be drawn with start point (h,v)
    while (k<=n) {
      // Draw line k
         if (k%3==0) g.setColor(Color.red);
         if (k%3==1) g.setColor(Color.blue);
         if (k%3==2) g.setColor(Color.green);
    
         int theta= k*turn % 360;
         double L= k*d;
         // Calculate the end point (h_next,v_next) of
         // the line
            int h_next= (int) Math.round(
                h+L*Math.cos(theta*Math.PI/180));
            int v_next= (int) Math.round(
                v+L*Math.sin(theta*Math.PI/180));
         g.drawLine(h,v,h_next, v_next);
        
      h= h_next; v= v_next;
      k= k+1;
      }
   }
}
